/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.status;

import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.config.UIInfoConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.util.UserRolePermissionsSet;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.status.AbstractStatusMonitor;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorBean;
import java.util.Map;
import java.util.Set;

public class ManagedObjectGroupStatusMonitor
extends AbstractStatusMonitor {
    private static final String TOTAL_TEXT_KEY = "status.mogroup.total";
    private static final String EXCEPTIONS_TEXT_KEY = "status.mogroup.exceptions";
    private static final String ATTENTIONS_TEXT_KEY = "status.mogroup.attentions";
    private static final String GROUP_PARAM_KEY = "group";
    private String className;

    public void init(String key, Map parameters, UIInfoConfigBean uiConfigBean) throws BonsaiConfigException {
        super.init(key, parameters, uiConfigBean);
        this.className = (String)parameters.get(GROUP_PARAM_KEY);
        if (this.className == null) {
            throw new BonsaiConfigException("'group' parameter is missing from the XML configuration!");
        }
    }

    public StatusMonitorBean getStatusMonitorBean(UISession session) {
        boolean acceptable;
        String id = ManagedObjectGroupStatusMonitor.getShortId(this.className, session);
        if (id == null) {
            return null;
        }
        UIObjectsReader reader = session.getUIObjectsReader();
        int total = reader.getLeavesForGroup(id).size();
        LocalizableText[] details = null;
        if (total == 0) {
            acceptable = true;
            details = new LocalizableText[]{new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", TOTAL_TEXT_KEY, new String[]{"0"})};
        } else {
            int exceptions = reader.getUnacceptableManagedObjectShortIdsForGroup(id).size();
            int attentions = reader.getAttentionManagedObjectShortIdsForGroup(id).size();
            acceptable = exceptions == 0 && attentions == 0;
            details = new LocalizableText[]{new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", TOTAL_TEXT_KEY, new String[]{String.valueOf(total)}), new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", EXCEPTIONS_TEXT_KEY, new String[]{String.valueOf(exceptions)}), new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", ATTENTIONS_TEXT_KEY, new String[]{String.valueOf(attentions)})};
        }
        return new StatusMonitorBean(this.getKey(), this.getUIInfo(), acceptable, details, null);
    }

    private static String getShortId(String className, UISession session) {
        Set objIds = ManagedObjectManager.getManagedObjectManager().getInventoryObjectIds(new ClassId(className));
        if (objIds.isEmpty()) {
            return null;
        }
        ObjectId objId = (ObjectId)objIds.iterator().next();
        if (!new UserRolePermissionsSet(objId).isPermitted(session.getUserRoles())) {
            return null;
        }
        return UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager().getShortId(objId);
    }
}

